"""empty message

Revision ID: ddd30_schema
Revises: 8e66c5c6edac
Create Date: 2017-11-13 11:15:26.620343

"""

# revision identifiers, used by Alembic.
revision = 'ddd30_schema'
down_revision = '8e66c5c6edac'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

def upgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.create_table('tb_journal_log_vaso',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('action', sa.SmallInteger(), nullable=False),
    sa.Column('data', sa.Unicode(length=2138), nullable=False),
    sa.Column('port', sa.Integer(), nullable=True),
    sa.Column('type', sa.Integer(), nullable=False),
    sa.Column('expiration', sa.Integer(), nullable=False),
    sa.Column('risk_level', sa.Integer(), nullable=True),
    sa.Column('datamd5', sa.String(length=32), nullable=True),
    sa.Column('detectable', sa.SmallInteger(), nullable=True),
    sa.Column('violatedpolicy', sa.Unicode(length=1200), nullable=True),
    sa.Column('rootfilesha1', sa.String(length=40), nullable=True),
    sa.Column('sourcefilesha1', sa.String(length=40), nullable=True),
    sa.Column('sourcesampletype', sa.SmallInteger(), nullable=True),
    sa.Column('filtercrc', sa.String(length=10), nullable=True),
    sa.Column('extrainfo', postgresql.JSON(), nullable=True),
    sa.Column('last_update_time', sa.DateTime(), nullable=False),
    sa.Column('device_guid', sa.String(length=36), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_journal_log_vaso'))
    )
    op.create_table('tb_journal_rest_vaso',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('action', sa.SmallInteger(), nullable=False),
    sa.Column('data', sa.Unicode(length=2138), nullable=False),
    sa.Column('port', sa.Integer(), nullable=True),
    sa.Column('type', sa.Integer(), nullable=False),
    sa.Column('expiration', sa.Integer(), nullable=False),
    sa.Column('risk_level', sa.Integer(), nullable=True),
    sa.Column('datamd5', sa.String(length=32), nullable=True),
    sa.Column('detectable', sa.SmallInteger(), nullable=True),
    sa.Column('violatedpolicy', sa.Unicode(length=1200), nullable=True),
    sa.Column('rootfilesha1', sa.String(length=40), nullable=True),
    sa.Column('sourcefilesha1', sa.String(length=40), nullable=True),
    sa.Column('sourcesampletype', sa.SmallInteger(), nullable=True),
    sa.Column('filtercrc', sa.String(length=10), nullable=True),
    sa.Column('last_update_time', sa.DateTime(), nullable=False),
    sa.Column('device_guid', sa.String(length=36), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_journal_rest_vaso'))
    )
    op.create_table('tb_so_vaso',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('data', sa.Unicode(length=2138), nullable=False),
    sa.Column('port', sa.Integer(), nullable=True),
    sa.Column('type', sa.Integer(), nullable=False),
    sa.Column('expiration', sa.Integer(), nullable=False),
    sa.Column('risk_level', sa.Integer(), nullable=True),
    sa.Column('datamd5', sa.String(length=32), nullable=True),
    sa.Column('detectable', sa.SmallInteger(), nullable=True),
    sa.Column('violatedpolicy', sa.Unicode(length=1200), nullable=True),
    sa.Column('rootfilesha1', sa.String(length=40), nullable=True),
    sa.Column('sourcefilesha1', sa.String(length=40), nullable=True),
    sa.Column('sourcesampletype', sa.SmallInteger(), nullable=True),
    sa.Column('filtercrc', sa.String(length=10), nullable=True),
    sa.Column('last_update_time', sa.DateTime(), nullable=False),
    sa.Column('device_guid', sa.String(length=36), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_so_vaso')),
    sa.UniqueConstraint('type', 'data', name='uq_tb_so_vaso_type_data')
    )
    op.create_index(op.f('ix_tb_so_vaso_data'), 'tb_so_vaso', ['data'], unique=False)
    op.create_index(op.f('ix_tb_so_vaso_device_guid'), 'tb_so_vaso', ['device_guid'], unique=False)
    op.create_index(op.f('ix_tb_so_vaso_expiration'), 'tb_so_vaso', ['expiration'], unique=False)
    op.create_index('ix_tb_so_vaso_risk_level_data', 'tb_so_vaso', [sa.text(u'risk_level DESC'), 'data'], unique=False)
    op.create_table('tb_ioc_data',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('source', sa.Integer(), nullable=False),
    sa.Column('data', sa.Text(), nullable=False),
    sa.Column('data_type', sa.Integer(), nullable=False),
    sa.Column('risk_level', sa.Integer(), nullable=False),
    sa.Column('last_detection_time', sa.DateTime(timezone=True), nullable=False),
    sa.Column('log_receive_time', sa.DateTime(timezone=True), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_ioc_data')),
    sa.UniqueConstraint('source', 'data', 'data_type', 'risk_level', name='uq_tb_ioc_data_source_data_data_type_risk_level')
    )
    op.create_table('tb_so_blacklist',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('type_', sa.Integer(), nullable=False),
    sa.Column('data', sa.String(), nullable=False),
    sa.Column('source', sa.Integer(), nullable=False),
    sa.Column('description', sa.String(), nullable=True),
    sa.Column('creation_time_in_utc', sa.DateTime(), nullable=True),
    sa.Column('last_update_time_in_utc', sa.DateTime(), nullable=True),
    sa.Column('last_modifier_display_name', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_so_blacklist')),
    sa.UniqueConstraint('type_', 'data', name='uq_tb_so_blacklist_type_data')
    )
    op.create_table('tb_journal_log_blacklist',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('id_', sa.BigInteger(), nullable=False),
    sa.Column('action', sa.Integer(), nullable=False),
    sa.Column('type_', sa.Integer(), nullable=False),
    sa.Column('data', sa.String(), nullable=False),
    sa.Column('datamd5', sa.String(length=32), nullable=True),
    sa.Column('risk_level', sa.Integer(), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_journal_log_blacklist'))
    )
    op.drop_table('tb_rpc_task')
    op.create_table('tb_rpc_task',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('device_guid', sa.String(length=36), nullable=False),
    sa.Column('task_type', sa.Integer(), nullable=False),
    sa.Column('task_info', postgresql.JSON(), nullable=True),
    sa.Column('status', sa.Integer(), nullable=True),
    sa.Column('sub_status', sa.Integer(), nullable=True),
    sa.Column('status_details', sa.Text(), nullable=True),
    sa.Column('creator', sa.String(), nullable=True),
    sa.Column('created_time', sa.DateTime(timezone=True), nullable=False),
    sa.Column('last_modified_time', sa.DateTime(timezone=True), nullable=False),
    sa.Column('is_batch', sa.Boolean(), nullable=False, default=False),
    sa.Column('batch_id', sa.String(64), nullable=True),
    sa.Column('extra_info', postgresql.JSON(), nullable=True),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_rpc_task'))
    )
    op.add_column('tb_device_info', sa.Column('ioc_sync_info', postgresql.JSON(), nullable=True))
    op.create_table(
        'tb_yara_files',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('filename', sa.String(), nullable=False),
        sa.Column('filesize', sa.BigInteger(), nullable=False),
        sa.Column('rule_count', sa.Integer(), nullable=False),
        sa.Column('risk_level', sa.Integer(), nullable=False),
        sa.Column('extensions', postgresql.ARRAY(sa.String()), nullable=False),
        sa.Column('description', sa.String(length=512), nullable=True),
        sa.Column('create_time', sa.DateTime(), nullable=False),
        sa.Column('modify_time', sa.DateTime(), nullable=False),
        sa.Column('last_update_by', sa.String(length=512), nullable=False),
        sa.Column('content', sa.String(), nullable=False),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_yara_files')),
        sa.UniqueConstraint('filename', name='uq_tb_yara_files_filename')
    )
    op.create_table(
        'tb_yara_rules',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('rule_name', sa.String(), nullable=False),
        sa.Column('namespace', sa.String(), nullable=True),
        sa.PrimaryKeyConstraint('rule_name', name=op.f('pk_tb_yara_rules')),
        sa.UniqueConstraint('rule_name', name='uq_tb_yara_rules_filename'),
        sa.ForeignKeyConstraint(['id'], ['tb_yara_files.id'], name=op.f('fk_tb_yara_files_id_tb_yara_rules')),
    )
    op.create_table(
        'tb_yara_extensions',
        sa.Column('extension', sa.String(), nullable=False),
        sa.Column('last_updated_time', sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint('extension', name=op.f('pk_tb_yara_extensions')),
        sa.UniqueConstraint('extension', name='uq_tb_yara_extensions')
    )
    op.create_table('tb_3rd_systems',
        sa.Column('id', sa.String(length=10), nullable=False),
        sa.Column('enabled', sa.Boolean(), nullable=False),
        sa.Column('config', postgresql.JSON(), nullable=True),
        sa.Column('password', sa.String(), nullable=True),
        sa.Column('last_sync_ts', sa.DateTime(), nullable=True),
        sa.Column('run_status', sa.Integer(), nullable=False),
        sa.Column('run_error_code', sa.Integer(), nullable=False),
        sa.Column('last_start_run_ts', sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_3rd_systems'))
    )
    op.create_table('tb_3rd_sms_send0',
        sa.Column('data', sa.String(), nullable=False),
        sa.Column('data_type', sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint('data', 'data_type', name=op.f('pk_tb_3rd_sms_send0'))
    )
    op.create_table('tb_3rd_sms_send1',
        sa.Column('data', sa.String(), nullable=False),
        sa.Column('data_type', sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint('data', 'data_type', name=op.f('pk_tb_3rd_sms_send1'))
    )
    op.create_table('tb_so_whitelist',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('type_', sa.Integer(), nullable=False),
        sa.Column('data', sa.String(), nullable=False),
        sa.Column('source', sa.Integer(), nullable=False),
        sa.Column('description', sa.String(), nullable=True),
        sa.Column('creation_time_in_utc', sa.DateTime(), nullable=True),
        sa.Column('last_update_time_in_utc', sa.DateTime(), nullable=True),
        sa.Column('last_modifier_display_name', sa.String(), nullable=True),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_so_whitelist')),
        sa.UniqueConstraint('type_', 'data', name='uq_tb_so_whitelist_type_data')
    )
    op.create_table('tb_registered_client',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('client_uuid', sa.String(length=32), nullable=False),
        sa.Column('client_hostname', sa.Unicode(length=255), nullable=False),
        sa.Column('last_request_time', sa.DateTime(), nullable=False),
        sa.Column('used_protocol', sa.String(length=20), nullable=False),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_registered_client'))
    )
    op.create_table('tb_au_component_info',
                    sa.Column('id', sa.BigInteger(), nullable=False),
                    sa.Column('klass', sa.Integer(), nullable=False),
                    sa.Column('type_', sa.Integer(), nullable=False),
                    sa.Column('version', sa.String(), nullable=True),
                    sa.Column('last_update_time_in_utc', sa.DateTime(), nullable=True),
                    sa.Column('latest_version', sa.String(), nullable=True),
                    sa.Column('language', sa.Integer(), nullable=True),
                    sa.Column('platform', sa.Integer(), nullable=True),
                    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_au_component_info'))
                    )
    op.create_table('tb_stix_files',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('filename', sa.String(length=256), nullable=False),
        sa.Column('content_id', sa.BigInteger(), nullable=False),
        sa.Column('description', sa.String(length=512), nullable=True),
        sa.Column('imported_time', sa.DateTime(), nullable=False),
        sa.Column('importer', sa.String(), nullable=False),
        sa.Column('filesize', sa.BigInteger(), nullable=False),
        sa.Column('udso_number', sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_stix_files')),
        sa.UniqueConstraint('filename', name='uq_tb_stix_files_filename'),
        sa.UniqueConstraint('content_id', name='uq_tb_stix_files_content_id')
    )
    op.add_column('tb_session', sa.Column('mapped_id', sa.String(length=36), nullable=True))
    op.add_column('tb_session', sa.Column('mapped_device', postgresql.ARRAY(sa.String(length=36)), nullable=True))
    op.create_table('tb_taxii_setting',
        sa.Column('id', sa.BigInteger(), nullable=False),
        sa.Column('enabled', sa.Boolean(), nullable=False, default=False),
        sa.Column('collections', postgresql.ARRAY(sa.String()), nullable=False),
        sa.Column('username', sa.String(length=100), nullable=True),
        sa.Column('password', sa.String(), nullable=True),
        sa.Column('config', postgresql.JSON(), nullable=False),
        sa.Column('info', postgresql.JSON(), nullable=False),
        sa.Column('last_modified_time', sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_taxii_setting'))
    )
    op.create_table('tb_3rd_taxii_send0',
        sa.Column('data', sa.String(), nullable=False),
        sa.Column('data_type', sa.Integer(), nullable=False),
        sa.Column('source_type', sa.Integer(), nullable=False),
        sa.Column('last_update_time', sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint('data', 'data_type', 'source_type', 'last_update_time', name=op.f('pk_tb_3rd_taxii_send0'))
    )
    op.create_table('tb_3rd_taxii_send1',
        sa.Column('data', sa.String(), nullable=False),
        sa.Column('data_type', sa.Integer(), nullable=False),
        sa.Column('source_type', sa.Integer(), nullable=False),
        sa.Column('last_update_time', sa.DateTime(), nullable=False),
        sa.PrimaryKeyConstraint('data', 'data_type', 'source_type', 'last_update_time', name=op.f('pk_tb_3rd_taxii_send1'))
    )
    op.add_column('tb_syslog_forward_task', sa.Column('extra_info', postgresql.JSON(), nullable=True))
    op.create_table('tb_so_blacklist_journal',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('type_', sa.Integer(), nullable=False),
    sa.Column('data', sa.String(), nullable=False),
    sa.Column('action', sa.Integer(), nullable=False),
    sa.Column('severity', sa.Integer(), nullable=False),
    sa.Column('expiration', sa.Integer(), nullable=False),
    sa.Column('last_update_time', sa.DateTime(), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_so_blacklist_journal'))
    )
    ### end Alembic commands ###


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('tb_so_blacklist_journal')
    op.drop_table('tb_3rd_taxii_send1')
    op.drop_table('tb_3rd_taxii_send0')
    op.drop_table('tb_taxii_setting')
    op.drop_table('tb_stix_files')
    op.drop_table('tb_au_component_info')
    op.drop_table('tb_so_whitelist')
    op.drop_table('tb_journal_log_blacklist')
    op.drop_table('tb_so_blacklist')
    op.drop_table('tb_so_vaso')
    op.drop_table('tb_journal_rest_vaso')
    op.drop_table('tb_journal_log_vaso')
    op.drop_table('tb_ioc_data')
    op.drop_table('tb_rpc_task')
    op.drop_table('tb_yara_extensions')
    op.drop_table('tb_yara_rules')
    op.drop_table('tb_yara_files')
    op.drop_table('tb_3rd_systems')
    op.drop_table('tb_3rd_sms_send1')
    op.drop_table('tb_3rd_sms_send0')
    op.drop_table('tb_registered_client')
    op.create_table('tb_rpc_task',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('device_guid', sa.String(length=36), nullable=False),
    sa.Column('package_type', sa.Integer(), nullable=False),
    sa.Column('package_hash', sa.String(), nullable=False),
    sa.Column('package_info', postgresql.JSON(), nullable=True),
    sa.Column('log_info', postgresql.JSON(), nullable=True),
    sa.Column('status', sa.Integer(), nullable=False, default=1),
    sa.Column('creator', sa.BigInteger(), nullable=True),
    sa.Column('created_time', sa.DateTime(timezone=True), nullable=False),
    sa.Column('last_modified_time', sa.DateTime(timezone=True), nullable=False),
    sa.PrimaryKeyConstraint('id', name=op.f('pk_tb_rpc_task'))
    )
    op.drop_column('tb_device_info', 'ioc_sync_info')
    op.drop_column('tb_session', 'mapped_device')
    op.drop_column('tb_session', 'mapped_id')
    op.drop_column('tb_syslog_forward_task', 'extra_info')
    ### end Alembic commands ###
